/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.cca;

import dev.doctor4t.wathe.Wathe;
import dev.doctor4t.wathe.game.GameConstants;
import dev.doctor4t.wathe.game.GameFunctions;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ClientTickingComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class PlayerPoisonComponent
implements AutoSyncedComponent,
ServerTickingComponent,
ClientTickingComponent {
    public static final ComponentKey<PlayerPoisonComponent> KEY = ComponentRegistry.getOrCreate((class_2960)Wathe.id("poison"), PlayerPoisonComponent.class);
    public static final class_3545<Integer, Integer> clampTime = new class_3545((Object)800, (Object)1400);
    private final class_1657 player;
    public int poisonTicks = -1;
    private int initialPoisonTicks = 0;
    private int poisonPulseCooldown = 0;
    public float pulseProgress = 0.0f;
    public boolean pulsing = false;
    public UUID poisoner;

    public PlayerPoisonComponent(class_1657 player) {
        this.player = player;
    }

    public void sync() {
        KEY.sync((Object)this.player);
    }

    public void reset() {
        this.poisonTicks = -1;
        this.poisonPulseCooldown = 0;
        this.initialPoisonTicks = 0;
        this.pulseProgress = 0.0f;
        this.pulsing = false;
        this.sync();
    }

    public void clientTick() {
        if (this.poisonTicks > -1) {
            --this.poisonTicks;
        }
        if (this.poisonTicks > 0) {
            int ticksSinceStart = this.initialPoisonTicks - this.poisonTicks;
            if (ticksSinceStart < 200) {
                return;
            }
            int minCooldown = 10;
            int maxCooldown = 60;
            int dynamicCooldown = minCooldown + (int)((float)(maxCooldown - minCooldown) * ((float)this.poisonTicks / (float)((Integer)clampTime.method_15441()).intValue()));
            if (this.poisonPulseCooldown <= 0) {
                this.poisonPulseCooldown = dynamicCooldown;
                this.pulsing = true;
                float minVolume = 0.5f;
                float maxVolume = 1.0f;
                float volume = minVolume + (maxVolume - minVolume) * (1.0f - (float)this.poisonTicks / (float)((Integer)clampTime.method_15441()).intValue());
                this.player.method_17356(class_3417.field_38068, class_3419.field_15248, volume, 1.0f);
            } else {
                --this.poisonPulseCooldown;
            }
        } else {
            this.poisonPulseCooldown = 0;
        }
    }

    public void serverTick() {
        if (this.poisonTicks > -1) {
            --this.poisonTicks;
            if (this.poisonTicks == 0) {
                this.poisonTicks = -1;
                GameFunctions.killPlayer(this.player, true, this.poisoner == null ? null : this.player.method_37908().method_18470(this.poisoner), GameConstants.DeathReasons.POISON);
                this.poisoner = null;
                this.sync();
            }
        }
    }

    public void setPoisonTicks(int ticks, UUID poisoner) {
        this.poisoner = poisoner;
        this.poisonTicks = ticks;
        if (this.initialPoisonTicks == 0) {
            this.initialPoisonTicks = ticks;
        }
        this.sync();
    }

    public void writeToNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        if (this.poisoner != null) {
            tag.method_25927("poisoner", this.poisoner);
        }
        tag.method_10569("poisonTicks", this.poisonTicks);
        tag.method_10569("initialPoisonTicks", this.initialPoisonTicks);
    }

    public void readFromNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        this.poisoner = tag.method_10545("poisoner") ? tag.method_25926("poisoner") : null;
        this.poisonTicks = tag.method_10545("poisonTicks") ? tag.method_10550("poisonTicks") : -1;
        this.initialPoisonTicks = tag.method_10545("initialPoisonTicks") ? tag.method_10550("initialPoisonTicks") : 0;
    }
}

